--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueUsers

CREATE PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueUsers
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueUsers
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Get unique users from the access log
--==================================================================================
--Uses: NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog
--Uses: NWIC_PanelMgmt.App.NVCC_Users
--Uses: CDWWork.Patient.Patient
--Uses: CDWWork.SStaff.SStaff
BEGIN
	SELECT DISTINCT
		al.userID,
		s.StaffName,
		p.Sta3n
	FROM
		NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
		LEFT JOIN NWIC_PanelMgmt.App.NVCC_Users u
			ON al.UserID = u.DomainPlusNetworkUserName
		LEFT JOIN CDWWork.SStaff.SStaff s
			ON u.UserIEN = s.StaffIEN and u.Sta3n = s.Sta3n
	ORDER BY s.StaffName
END
GO

exec sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueUsers';